import { NextRequest, NextResponse } from "next/server"
import { wgApi } from "@/lib/wg-api"

export async function GET(
  request: NextRequest,
  { params }: { params: Promise<{ id: string }> }
) {
  try {
    const { id } = await params
    const qrCode = await wgApi.getClientQR(id)
    
    return new NextResponse(qrCode, {
      headers: {
        'Content-Type': 'image/svg+xml',
      },
    })
  } catch (error) {
    console.error("Error fetching QR code:", error)
    const errorMessage = error instanceof Error ? error.message : "Failed to fetch QR code"
    return NextResponse.json(
      { error: errorMessage },
      { status: 500 }
    )
  }
}

